<?php
include 'api/config.php';
$categories = [
    'Based Coffee' => 'Coffee Based',
    'Non-coffee'   => 'Non-Coffee',
    'Signature'    => 'Signature',
    'Snack'        => 'Snack'
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Pesan Menu | Low.Fee Coffee</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
  :root {
    --bs-primary-rgb: 88, 62, 43;
    --bs-secondary-rgb: 245, 235, 224;
    --bs-dark-rgb: 25, 25, 25;
    --font-family-sans-serif: 'Poppins', sans-serif;
  }
  body { background-color: #fdfaf6; font-family: var(--font-family-sans-serif); }
  .navbar { background-color: #fff; box-shadow: 0 2px 15px rgba(0,0,0,0.05); }
  .navbar-brand { font-weight: 700; color: rgb(var(--bs-primary-rgb)); }
  .nav-pills .nav-link { color: #555; font-weight: 500; border-radius: 50px; padding: 8px 20px; transition: all 0.3s ease; }
  .nav-pills .nav-link.active, .nav-pills .show > .nav-link { background-color: rgb(var(--bs-primary-rgb)); color: #fff; }
  .menu-card { border: none; border-radius: 1rem; overflow: hidden; transition: all 0.3s ease; box-shadow: 0 4px 20px rgba(0,0,0,0.08); }
  .menu-card img { height: 200px; object-fit: cover; }
  .menu-card .card-title { font-weight: 600; color: #333; }
  .menu-card .card-text { max-height: 50px; overflow: hidden; transition: max-height 0.3s ease; }
  .menu-card .price { font-size: 1.5rem; font-weight: 700; color: rgb(var(--bs-primary-rgb)); }
  .btn-primary { background-color: rgb(var(--bs-primary-rgb)); border-color: rgb(var(--bs-primary-rgb)); font-weight: 500; }
  .cart-box { background: #fff; padding: 1rem; border-radius: 1rem; box-shadow: 0 4px 20px rgba(0,0,0,0.08); position: sticky; top: 20px; }
  .footer { background: rgb(var(--bs-primary-rgb)); color: #fff; padding: 1rem; text-align: center; }
  .mobile-cart-fab { position: fixed; bottom: 20px; right: 20px; width: 60px; height: 60px; border-radius: 50%; background-color: rgb(var(--bs-primary-rgb)); color: #fff; display: flex; align-items: center; justify-content: center; font-size: 1.8rem; box-shadow: 0 4px 15px rgba(0,0,0,0.2); z-index: 1040; }
  .disabled-menu { opacity: 0.5; background-color: gray !important; border-color: gray !important; cursor: not-allowed !important; }
</style>
</head>
<body>
<nav class="navbar sticky-top py-3">
  <div class="container">
    <a class="navbar-brand d-flex align-items-center" href="index.html">
      <i class="bi bi-cup-hot-fill me-2"></i>
      Low.Fee Coffee
    </a>
  </div>
</nav>

<div class="container my-5">
  <div class="text-center mb-5">
    <h1 class="display-5 fw-bold">Pilih Menu Favoritmu</h1>
    <p class="lead text-muted">Kopi berkualitas tinggi dan cemilan lezat menanti.</p>
  </div>
  
  <div class="row g-5">
    <div class="col-lg-8">
      <ul class="nav nav-pills mb-4 justify-content-center" id="menuTab" role="tablist">
        <?php $i=0; foreach($categories as $key=>$val): ?>
        <li class="nav-item mx-1" role="presentation">
          <button class="nav-link <?= $i==0?'active':'' ?>" id="tab-<?= $i ?>" data-bs-toggle="tab" data-bs-target="#cat-<?= $i ?>" type="button" role="tab"><?= $val ?></button>
        </li>
        <?php $i++; endforeach; ?>
      </ul>
      
      <div class="tab-content mt-5">
        <?php $i=0; foreach($categories as $key=>$val): ?>
        <div class="tab-pane fade <?= $i==0?'show active':'' ?>" id="cat-<?= $i ?>" role="tabpanel" tabindex="0">
          <div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 g-4">
            <?php
            $stmt = $conn->prepare("SELECT * FROM menu WHERE category=?");
            $stmt->bind_param('s', $key);
            $stmt->execute();
            $result = $stmt->get_result();
            if ($result->num_rows > 0):
              while($row = $result->fetch_assoc()):
            ?>
            <div class="col">
              <div class="card menu-card h-100">
                <img src="assets/uploads/<?= htmlspecialchars($row['image']) ?>" alt="<?= htmlspecialchars($row['name']) ?>" />
                <div class="card-body d-flex flex-column">
                  <h5 class="card-title mb-1"><?= htmlspecialchars($row['name']) ?></h5>
                  <p class="card-text mb-2"><?= htmlspecialchars($row['description']) ?></p>
                  <p class="price mt-auto mb-3">Rp <?= number_format($row['price'],0,',','.') ?></p>
                  <button class="btn btn-primary w-100 add-to-cart <?= (isset($row['avaiable']) && $row['avaiable'] == 1) ? '' : 'disabled-menu' ?>" <?= (isset($row['avaiable']) && $row['avaiable'] == 1) ? '' : 'disabled' ?> data-id="<?= $row['id'] ?>" data-name="<?= htmlspecialchars($row['name']) ?>" data-price="<?= $row['price'] ?>">
                    <i class="bi bi-cart-plus me-1"></i> Tambah
                  </button>
                </div>
              </div>
            </div>
            <?php endwhile; else: ?>
              <p class="text-center text-muted col-12">Menu untuk kategori ini akan segera hadir.</p>
            <?php endif; $stmt->close(); ?>
          </div>
        </div>
        <?php $i++; endforeach; ?>
      </div>
    </div>

    <div class="col-lg-4 d-none d-lg-block">
      <div class="cart-box">
        <h4 class="fw-bold mb-4 text-center"><i class="bi bi-cart3 me-2"></i>Keranjang Anda</h4>
        
        <div class="mb-3">
          <label for="table_number_desktop" class="form-label fw-bold">Nomor Meja</label>
          <input type="text" id="table_number_desktop" class="form-control form-control-lg" placeholder="Ketik nomor meja Anda" required />
        </div>
        
        <div class="mb-3">
          <label for="name_desktop" class="form-label fw-bold">Nama Customer</label>
          <input type="text" id="name_desktop" class="form-control form-control-lg" placeholder="Ketik nama anda" required />
        </div>
        
        <div class="mb-3">
          <label for="phone_desktop" class="form-label fw-bold">Nomor HP</label>
          <input type="text" id="phone_desktop" class="form-control form-control-lg" placeholder="Ketik nomor hp anda" required />
        </div>
        
        
        
        <hr class="my-4">
            <div id="cart-items-desktop">
                <p class="text-center text-muted">Keranjang masih kosong.</p>
            </div>
        <hr class="my-4">
            <div class="d-flex justify-content-between align-items-center mb-3">
              <span class="fs-5 fw-medium">Total:</span>
              <strong id="cart-total-desktop" class="fs-4 fw-bold" style="color:rgb(var(--bs-primary-rgb));">Rp 0</strong>
            </div>
        <div class="mb-3">
          <label class="form-label fw-bold">Opsi Pembayaran</label>
          <div class="d-flex justify-content-around p-2 rounded" style="background-color: #f8f9fa;">
            <div class="form-check">
              <input class="form-check-input payment-option-desktop" type="radio" name="payment_option_desktop" id="pay_cash_desktop" value="cash" checked />
              <label class="form-check-label" for="pay_cash_desktop"><i class="bi bi-cash-coin"></i> Cash</label>
            </div>
          </div>
        </div>
        <div class="mb-4">
          <label for="order_note_desktop" class="form-label fw-bold">Catatan (Opsional)</label>
          <textarea id="order_note_desktop" class="form-control" rows="2" placeholder="Contoh: Tanpa gula, es sedikit..."></textarea>
        </div>
        <button class="btn btn-primary btn-lg w-100 checkout-button" data-view="desktop">
          Pesan Sekarang <i class="bi bi-arrow-right-circle ms-1"></i>
        </button>
      </div>
    </div>
  </div>
</div>

<a class="mobile-cart-fab d-lg-none" data-bs-toggle="offcanvas" href="#offcanvasCart" role="button" aria-controls="offcanvasCart">
  <i class="bi bi-cart3"></i>
  <span class="cart-count-badge" id="mobile-cart-count" style="display: none;">0</span>
</a>

<div class="offcanvas offcanvas-end d-lg-none" tabindex="-1" id="offcanvasCart" aria-labelledby="offcanvasCartLabel">
  <div class="offcanvas-header border-bottom">
    <h5 class="offcanvas-title fw-bold" id="offcanvasCartLabel"><i class="bi bi-cart3 me-2"></i>Keranjang Anda</h5>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    <div class="mb-3">
      <label for="table_number_mobile" class="form-label fw-bold">Nomor Meja</label>
      <input type="text" id="table_number_mobile" class="form-control form-control-lg" placeholder="Ketik nomor meja Anda" required />
    </div>
    
    <div class="mb-3">
      <label for="name_mobile" class="form-label fw-bold">Nama Customer</label>
      <input type="text" id="name_mobile" class="form-control form-control-lg" placeholder="Ketik nama Anda" required />
    </div>
    
    <div class="mb-3">
      <label for="phone_mobile" class="form-label fw-bold">Nomor HP</label>
      <input type="text" id="phone_mobile" class="form-control form-control-lg" placeholder="Ketik nomor Hp Anda" required />
    </div>
    <hr class="my-4">
    <div id="cart-items-mobile">
      <p class="text-center text-muted">Keranjang masih kosong.</p>
    </div>
    <hr class="my-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <span class="fs-5 fw-medium">Total:</span>
      <strong id="cart-total-mobile" class="fs-4 fw-bold" style="color:rgb(var(--bs-primary-rgb));">Rp 0</strong>
    </div>
    <div class="mb-3">
      <label class="form-label fw-bold">Opsi Pembayaran</label>
      <div class="d-flex justify-content-around p-2 rounded" style="background-color: #f8f9fa;">
        <div class="form-check">
          <input class="form-check-input payment-option-mobile" type="radio" name="payment_option_mobile" id="pay_cash_mobile" value="cash" checked />
          <label class="form-check-label" for="pay_cash_mobile"><i class="bi bi-cash-coin"></i> Cash</label>
        </div>
      </div>
    </div>
    <div class="mb-4">
      <label for="order_note_mobile" class="form-label fw-bold">Catatan (Opsional)</label>
      <textarea id="order_note_mobile" class="form-control" rows="2" placeholder="Contoh: Tanpa gula, es sedikit..."></textarea>
    </div>
    <button class="btn btn-primary btn-lg w-100 checkout-button" data-view="mobile">
      Pesan Sekarang <i class="bi bi-arrow-right-circle ms-1"></i>
    </button>
  </div>
</div>

<div class="footer">
  &copy; <?= date('Y') ?> LowFeeCoffee. Dibuat dengan <i class="bi bi-heart-fill text-danger"></i> untuk para penikmat kopi.
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  let cart = JSON.parse(localStorage.getItem('cart')) || {};
  const offcanvasCart = new bootstrap.Offcanvas(document.getElementById('offcanvasCart'));

  function renderCart() {
    const desktopContainer = document.getElementById('cart-items-desktop');
    const mobileContainer = document.getElementById('cart-items-mobile');
    const desktopTotalEl = document.getElementById('cart-total-desktop');
    const mobileTotalEl = document.getElementById('cart-total-mobile');
    const mobileCartBadge = document.getElementById('mobile-cart-count');

    desktopContainer.innerHTML = '';
    mobileContainer.innerHTML = '';

    if (Object.keys(cart).length === 0) {
      const emptyMsg = '<p class="text-center text-muted">Keranjang masih kosong.</p>';
      desktopContainer.innerHTML = emptyMsg;
      mobileContainer.innerHTML = emptyMsg;
      desktopTotalEl.innerText = 'Rp 0';
      mobileTotalEl.innerText = 'Rp 0';
      mobileCartBadge.style.display = 'none';
      return;
    }

    let grandTotal = 0;
    let totalItems = 0;
    
    for (const id in cart) {
      const item = cart[id];
      const subtotal = item.price * item.qty;
      grandTotal += subtotal;
      totalItems += item.qty;

      const cartItemHTML = `
        <div class="cart-item">
            <div class="cart-item-details">
                <div class="cart-item-name">${item.name}</div>
                <div class="cart-item-price">Rp ${item.price.toLocaleString()}</div>
            </div>
            <div class="cart-item-actions">
                <input type="number" min="1" value="${item.qty}" class="form-control form-control-sm cart-item-qty" data-id="${id}" />
                <div class="cart-item-remove" data-id="${id}" title="Hapus item">&times;</div>
            </div>
        </div>
      `;
      desktopContainer.innerHTML += cartItemHTML;
      mobileContainer.innerHTML += cartItemHTML;
    }

    desktopTotalEl.innerText = 'Rp ' + grandTotal.toLocaleString();
    mobileTotalEl.innerText = 'Rp ' + grandTotal.toLocaleString();
    
    mobileCartBadge.innerText = totalItems;
    mobileCartBadge.style.display = 'block';

    document.querySelectorAll('.cart-item-qty').forEach(input => {
      if (!input.dataset.listenerAttached) {
        input.addEventListener('change', handleQtyChange);
        input.dataset.listenerAttached = 'true';
      }
    });
    document.querySelectorAll('.cart-item-remove').forEach(btn => {
      if (!btn.dataset.listenerAttached) {
        btn.addEventListener('click', handleRemoveItem);
        btn.dataset.listenerAttached = 'true';
      }
    });
  }

  function handleQtyChange(e) {
    const id = e.target.dataset.id;
    let val = parseInt(e.target.value);
    if (val < 1 || isNaN(val)) val = 1;
    cart[id].qty = val;
    localStorage.setItem('cart', JSON.stringify(cart));
    renderCart();
  }

  function handleRemoveItem(e) {
    const id = e.target.dataset.id;
    delete cart[id];
    localStorage.setItem('cart', JSON.stringify(cart));
    renderCart();
  }

  document.querySelectorAll('.add-to-cart').forEach(btn => {
    btn.addEventListener('click', () => {
      if (btn.classList.contains('disabled-menu') || btn.disabled) {
        return;
      }
      const id = btn.dataset.id;
      const name = btn.dataset.name;
      const price = parseInt(btn.dataset.price);
      if (!cart[id]) {
        cart[id] = { name, price, qty: 1 };
      } else {
        cart[id].qty++;
      }
      localStorage.setItem('cart', JSON.stringify(cart));
      renderCart();
      
      const originalText = btn.innerHTML;
      btn.innerHTML = '<i class="bi bi-check-lg"></i> Ditambahkan!';
      btn.disabled = true;
      setTimeout(() => {
          btn.innerHTML = originalText;
          btn.disabled = false;
      }, 1500);
    });
  });

  document.querySelectorAll('.checkout-button').forEach(btn => {
    btn.addEventListener('click', function() {
      const view = this.dataset.view;
      const button = this;
      const originalButtonText = button.innerHTML;
      
      const tableNumber = document.getElementById(`table_number_${view}`).value.trim();
      const customerName = document.getElementById(`name_${view}`).value.trim();
      const customerPhone = document.getElementById(`phone_${view}`).value.trim();
      const paymentOption = document.querySelector(`input[name="payment_option_${view}"]:checked`).value;
      const note = document.getElementById(`order_note_${view}`).value.trim();

      if (!tableNumber) {
        alert('Mohon isi nomor meja Anda.');
        return;
      }
      if (Object.keys(cart).length === 0) {
        alert('Keranjang Anda masih kosong.');
        return;
      }

      button.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></ span> Memproses...';
      button.disabled = true;

      fetch('api/checkout.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
          cart: Object.fromEntries(Object.entries(cart).map(([id, v]) => [id, v.qty])),
          table_number: tableNumber,
          customer_name:customerName,
          customer_phone:customerPhone,
          payment_option: paymentOption,
          note: note
        })
      })
      .then(res => res.json())
      .then(data => {
        if (data.success && data.order_id) {
            cart = {};
            localStorage.removeItem('cart');
            window.location.href = `invoice.php?id=${data.order_id}`;
        } else {
            alert('Gagal memproses pesanan: ' + (data.message || 'Error tidak diketahui.'));
            button.innerHTML = originalButtonText;
            button.disabled = false;
        }
      })
      .catch(error => {
        alert('Terjadi kesalahan jaringan. Silakan coba lagi.');
        console.error('Checkout Error:', error);
        button.innerHTML = originalButtonText;
        button.disabled = false;
      });
    });
  });

  window.onload = renderCart;

  document.querySelectorAll('.read-more').forEach(button => {
    button.addEventListener('click', function() {
        const cardText = this.previousElementSibling;
        cardText.classList.toggle('expanded');
        this.innerText = cardText.classList.contains('expanded') ? 'Sembunyikan' : 'Baca Selengkapnya';
    });
  });

  renderCart();
</script>
</body>
</html> 