<?php
session_start(); // Pastikan sesi dimulai

// TAMBAHKAN BLOK PENGAMANAN INI
if (!isset($_SESSION['admin'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Akses ditolak: Anda harus login sebagai admin.']);
    exit;
}

include 'config.php';
header('Content-Type: application/json');

$id = $_POST['id'] ?? 0;
$status = $_POST['status'] ?? '';

if ($id && $status) {
    $stmt = $conn->prepare("UPDATE orders SET status=? WHERE id=?");
    $stmt->bind_param('si', $status, $id);
    if ($stmt->execute()) {
        echo json_encode(['success'=>true]);
    } else {
        echo json_encode(['success'=>false, 'message'=>'Gagal memperbarui database.']);
    }
} else {
    echo json_encode(['success'=>false, 'message'=>'Data tidak lengkap']);
}
?>