<?php
session_start();
if (!isset($_SESSION['admin'])) header('Location: index.php');
include '../api/config.php';

$report = $conn->query("
  SELECT m.name, SUM(oi.quantity) as total_sold, SUM(oi.quantity*m.price) as total_income
  FROM order_items oi
  JOIN menu m ON oi.menu_id=m.id
  JOIN orders o ON oi.order_id=o.id
  WHERE o.status='done'
  GROUP BY oi.menu_id
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Penjualan | LowFeeCoffee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
    body {
        background-color: #f8f1e4;
        color: #4e342e;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .main-header {
        background-color: #8d6e63;
        color: white;
    }

    .text-coffee {
        color: white;
    }

    .btn-secondary {
        background-color: #bcaaa4;
        border-color: #bcaaa4;
        color: #4e342e;
    }

    .btn-secondary:hover {
        background-color: #a1887f;
        border-color: #a1887f;
        color: #fff;
    }

    .table {
        border-collapse: separate;
        border-spacing: 0 0.5rem;
        color: #4e342e;
    }

    .table thead {
        background-color: #d7ccc8;
        color: #3e2723;
        font-weight: 600;
    }

    .table thead th {
        border: none;
        padding: 12px;
        font-size: 0.95rem;
    }

    .table tbody tr {
        background-color: #fffaf5;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        transition: background-color 0.2s ease;
    }

    .table tbody tr:hover {
        background-color: #f3e5f5;
    }

    .table tbody td {
        padding: 14px;
        vertical-align: middle;
        border-top: 1px solid #e0cfc2;
        font-size: 0.95rem;
    }

    h2, h1 {
        font-weight: bold;
    }

    @media (max-width: 576px) {
        .main-header .container {
            flex-direction: column;
            align-items: start;
        }

        .main-header h1 {
            margin-bottom: 10px;
        }
    }
</style>

</head>
<body>

<!-- Header -->
<header class="main-header shadow-sm py-3 mb-4">
    <div class="container d-flex justify-content-between align-items-center">
        <h1 class="fs-4 m-0 fw-bold text-coffee">Laporan Penjualan Per-Menu</h1>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
            <i class="bi bi-box-arrow-right"></i> Logout
        </a>
    </div>
</header>

<!-- Konten -->
<div class="container mb-5">
    <div class="table-responsive shadow-sm rounded bg-white p-3">
        <table class="table table-bordered table-striped align-middle">
            <thead>
                <tr>
                    <th>Menu</th>
                    <th>Terjual</th>
                    <th>Pendapatan</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $report->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= $row['total_sold'] ?></td>
                    <td>Rp<?= number_format($row['total_income'],0,',','.') ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
    <a href="dashboard.php" class="btn btn-secondary mt-4">
        <i class="bi bi-arrow-left"></i> Kembali ke Dashboard
    </a>
</div>

</body>
</html>
