<?php
session_start();
if (!isset($_SESSION['admin'])) die("Akses ditolak!");

include '../api/config.php';

$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date   = $_GET['end_date'] ?? date('Y-m-d');

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=laporan_penjualan_{$start_date}sd{$end_date}.xls");
?>

<html xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
    <meta charset="UTF-8">
</head>
<body>
    <table border="1">
        <thead>
            <tr style="background-color:#f2f2f2;">
                <th>ID Pesanan</th>
                <th>Meja</th>
                <th>Waktu</th>
                <th>Menu</th>
                <th>Total</th>
                <th>Catatan</th>
                <th>Opsi Pembayaran</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $stmt = $conn->prepare("
            SELECT o.id, o.table_number, o.order_time, o.note, o.payment_option,
                   GROUP_CONCAT(CONCAT(m.name, ' x', oi.quantity) SEPARATOR ', ') AS items, 
                   SUM(oi.quantity * m.price) AS total
            FROM orders o
            JOIN order_items oi ON o.id = oi.order_id
            JOIN menu m ON oi.menu_id = m.id
            WHERE o.status = 'done' AND DATE(o.order_time) BETWEEN ? AND ?
            GROUP BY o.id
            ORDER BY o.order_time DESC
        ");
        $stmt->bind_param('ss', $start_date, $end_date);
        $stmt->execute();
        $res = $stmt->get_result();

        $grand_total = 0;
        while ($row = $res->fetch_assoc()):
            $grand_total += $row['total'];
        ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['table_number']) ?></td>
                <td><?= $row['order_time'] ?></td>
                <td><?= htmlspecialchars($row['items']) ?></td>
                <td>Rp<?= number_format($row['total'], 0, ',', '.') ?></td>
                <td><?= htmlspecialchars($row['note']) ?></td>
                <td><?= htmlspecialchars($row['payment_option']) ?></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="4" align="right"><strong>Total Pendapatan</strong></td>
                <td colspan="3"><strong>Rp<?= number_format($grand_total, 0, ',', '.') ?></strong></td>
            </tr>
        </tfoot>
    </table>
</body>
</html>